 /*******************************************************************
 *
 *  DESCRIPTION: Atomic Model Queue
 *
 *  AUTHOR: Misagh Tavanpour
 *
 *  DATE: 22/10/2012
 *
 *******************************************************************/

 #ifndef __QUEUE2_H
 #define __QUEUE2_H

 #include "atomic.h"     // class Atomic
 #include "string.h"	 // class String
 #include "list.h"

 class Queue2 : public Atomic
 {
   public:
	       Queue2( const std::string &name = "Queue2" );	//Default constructor
	       virtual std::string className() const { return "Queue2"; }
	       ~Queue2();

   protected:
	          Model &initFunction();
	          Model &externalFunction( const ExternalMessage & );
	          Model &internalFunction( const InternalMessage & );
	          Model &outputFunction( const InternalMessage & );

   private:
	        const Port &In,&Req;
	        Port &Out;
	        Time ProcessTime;
	        typedef list<Value> ElementList ;
	        ElementList elements;
	        int Request;
	        int Qlen;
         	enum State{
			            Idle,       //initial state
			            Push,
			            Pop,
		              };
		    State state;
 };	// class Queue2

 #endif   //__QUEUE2_H
